
<?php $__env->startSection('title', 'SIPIJAR - Pengaturan Akun'); ?>
<?php $__env->startSection('header', 'Pengaturan Akun'); ?>
<?php $__env->startSection('konten'); ?>
    <div class="row">
        <div class="col-12 col-lg-4">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-center align-items-center flex-column">
                        <div class="avatar avatar-2xl">
                            <img src="<?php echo e(route('foto.profil', ['userId' => auth()->user()->id, 'filename' => basename(auth()->user()->foto)])); ?>" alt="Avatar">
                        </div>

                        <h3 class="mt-3"><?php echo e(auth()->user()->nama); ?></h3>
                        <p class="text-small"><?php echo e(auth()->user()->hak_akses); ?></p>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12 col-lg-8">
            <div class="card">
                <div class="card-body">
                    <form action="<?php echo e(route('pengaturan.update', auth()->user()->id)); ?>" method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div class="form-group">
                            <label for="nama" class="form-label">Nama Lengkap <span class="text-danger">*</span></label>
                            <input type="text" name="nama" id="nama" class="form-control" placeholder="Masukkan Nama Lengkap" value="<?php echo e(auth()->user()->nama); ?>" required autofocus>
                        </div>
                        <div class="form-group">
                            <label for="nomor_induk" class="form-label">Nomor Induk <span class="text-danger">*</span></label>
                            <input type="text" name="nomor_induk" id="nomor_induk" class="form-control" placeholder="Masukkan Nomor Induk" value="<?php echo e(auth()->user()->nomor_induk); ?>" disabled>
                        </div>
                        <div class="form-group">
                            <label for="password" class="form-label">Password</label>
                            <input type="password" name="password" id="password" class="form-control" placeholder="Masukkan Password">
                            <small class="text-danger">Kosongkan jika tidak ingin mengganti Password</small>
                        </div>
                        <div class="form-group">
                            <label for="email" class="form-label">Email</label>
                            <input type="email" name="email" id="email" class="form-control" placeholder="Masukkan Email" value="<?php echo e(auth()->user()->email ?? ''); ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="file" class="form-label">Foto</label>
                            <input type="file" name="file" id="file" class="form-control" accept="image/png, image/jpeg, image/jpg">
                            <small class="text-danger">Kosongkan jika tidak ingin mengganti Foto</small>
                        </div>
                            <div class="form-group">
                                <label for="role" class="form-label">Hak Akses <span class="text-danger">*</span></label>
                                <select name="role" id="role" class="form-select" disabled>
                                    <option value="">-- Pilih Hak Akses --</option>
                                    <option value="Admin"<?php echo e(auth()->user()->hak_akses == 'Admin' ? 'selected' : '' ); ?>>Admin</option>
                                    <option value="SDI" <?php echo e(auth()->user()->hak_akses == 'SDI' ? 'selected' : '' ); ?>>SDI</option>
                                    <option value="Mitra" <?php echo e(auth()->user()->hak_akses == 'Mitra' ? 'selected' : '' ); ?>>Mitra</option>
                                </select>
                            </div>
                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\KAMPUS\SEMESTER 6\KP\aplikasi\SIPIJAR\resources\views/main/pengaturan.blade.php ENDPATH**/ ?>