
<?php $__env->startSection('title', 'SIPAJAR - Data Poligon'); ?>
<?php $__env->startSection('header', 'Data Poligon'); ?>
<?php $__env->startSection('konten'); ?>
    <div class="card">
        <div class="card-header">
            <div class="d-grip gap-2 d-md-flex justify-content-md-end">
                <a href="<?php echo e(route('poligon.create')); ?>" class="btn btn-primary me-md-2"><i class="bi bi-plus-lg"></i> Tambah
                    Data</a>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover table-bordered" id="table1">
                    <thead>
                        <tr>
                            <th class="text-center">No</th>
                            <th class="text-center">Branch</th>
                            <th class="text-center">Nama Proyek</th>
                            <th class="text-center">Tipe Desain</th>
                            <th class="text-center">Total BoQ</th>
                            <th class="text-center">Mitra</th>
                            <th class="text-center">Catatan</th>
                            <th class="text-center">Status</th>
                            <th class="text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            $no = 1;
                        ?>
                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($no++); ?></td>
                                <td><?php echo e($d->branch->nama ?? 'Branch Terhapus'); ?></td>
                                <td><?php echo e($d->nama); ?></td>
                                <td><?php echo e($d->tipe); ?></td>
                                <td><?php echo e(number_format($d->total_boq, 0, ',', '.')); ?></td>
                                <td><?php echo e($d->user->nama ?? $d->nama_user); ?></td>
                                <td><button type="button" class="btn btn-outline-success btn-sm" data-bs-toggle="modal"
                                        data-bs-target="#catatan<?php echo e($d->id); ?>">
                                        Catatan
                                    </button></td>
                                <td>
                                    <?php if(auth()->user()->hak_akses === 'Mitra'): ?>
                                        <span class="d-block mb-1"><?php echo e($d->status); ?></span>
                                    <?php else: ?>    
                                        <select class="form-select form-control status-select" data-id="<?php echo e($d->id); ?>">
                                            <option value="">-- Pilih Update Status --</option>
                                            <option value="review" <?php echo e($d->status === 'review' ? 'selected' : ''); ?>>Review</option>
                                            <option value="revisi" <?php echo e($d->status === 'revisi' ? 'selected' : ''); ?>>Revisi</option>
                                            <option value="approval" <?php echo e($d->status === 'approval' ? 'selected' : ''); ?>>Approval</option>
                                            <option value="kendala" <?php echo e($d->status === 'kendala' ? 'selected' : ''); ?>>Kendala</option>
                                        </select>
                                        <span class="text-success small mt-1 status-message" style="display: none;"></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('poligon.show', $d->id)); ?>" class="btn btn-success btn-sm m-1"><i
                                            class="bi bi-eye-fill"></i> View</a>
                                    <?php if($d->status === 'revisi' && auth()->user()->hak_akses === 'Mitra'): ?>
                                        <a href="<?php echo e(route('poligon.edit', $d->id)); ?>" class="btn btn-primary btn-sm m-1"><i
                                                class="bi bi-pencil-square"></i> Edit</a>
                                    <?php endif; ?>
                                    <?php if(auth()->user()->hak_akses !== 'Mitra'): ?>
                                        <a href="<?php echo e(route('poligon.edit', $d->id)); ?>" class="btn btn-primary btn-sm m-1"><i
                                            class="bi bi-pencil-square"></i> Edit</a>
                                        <form onsubmit="return confirm('Apakah Anda Yakin ?');"
                                            action="<?php echo e(route('poligon.destroy', $d->id)); ?>" method="POST" name="hapus">
                                            <?php echo method_field('DELETE'); ?>
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="btn btn-sm btn-danger m-1"><i
                                                    class="bi bi-trash"></i>
                                                Delete</button>
                                        </form>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <!--scrolling content Modal -->
    <div class="modal fade" id="catatan<?php echo e($d->id); ?>" tabindex="-1" role="dialog"
        aria-labelledby="titlecatatan<?php echo e($d->id); ?>" aria-hidden="true">
        <div class="modal-dialog modal-dialog-scrollable" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="titlecatatan<?php echo e($d->id); ?>">
                        Catatan Poligon Branch <?php echo e($d->branch->nama ?? '-'); ?> Proyek <?php echo e($d->nama); ?>

                    </h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i data-feather="x"></i>
                    </button>
                </div>

                <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('catatan-poligon', ['id_poligon' => $d->id]);

$__html = app('livewire')->mount($__name, $__params, 'catatan-' . $d->id, $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
            </div>
        </div>
    </div>
    <?php $__env->startPush('script'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const modal = document.getElementById('catatan<?php echo e($d->id); ?>');
            if (modal) {
                modal.addEventListener('shown.bs.modal', function () {
                    Livewire.dispatch('mulaiPolling');
                });
                modal.addEventListener('hidden.bs.modal', function () {
                    Livewire.dispatch('berhentiPolling');
                });
            }

            Livewire.hook('message.processed', (message, component) => {
                const container = document.querySelector('#list-catatan-<?php echo e($d->id); ?>');
                if (container) {
                    container.scrollTop = container.scrollHeight;
                }
            });
        });
    </script>
    <?php $__env->stopPush(); ?>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            document.querySelectorAll('.status-select').forEach(select => {
                select.addEventListener('change', function () {
                    const id = this.getAttribute('data-id');
                    const status = this.value;
                    const messageSpan = this.nextElementSibling;

                    fetch("<?php echo e(route('poligon.updateStatus')); ?>", {
                        method: "POST",
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                        },
                        body: JSON.stringify({ id, status })
                    })
                    .then(res => res.json())
                    .then(data => {
                        messageSpan.textContent = data.message;
                        messageSpan.style.display = 'inline';
                        setTimeout(() => {
                            messageSpan.style.display = 'none';
                        }, 2000);
                    })
                    .catch(err => {
                        alert('Gagal update status');
                        console.error(err);
                    });
                });
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layout.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\KAMPUS\SEMESTER 6\KP\aplikasi\SIPIJAR\resources\views/order/poligon.blade.php ENDPATH**/ ?>