<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Akun Email</title>
    <style>
        body {
            font-family: Arial, Helvetica, sans-serif;
            background-color: #f4f4f4;
            color: #333;
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 600px;
            margin: 20px auto;
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        .header {
            background-color: #007bff;
            color: #fff;
            text-align: center;
            padding: 15px;
            border-radius: 8px 8px 0 0;
        }

        .header h2{
            margin: 0;
        }

        .content {
            padding: 20px;
            line-height: 1.6;
        }

        .content p {
            font-size: 16px;
            margin: 10px 0;
        }

        .content .strong {
            font-weight: bold;
        }

        .footer {
            text-align: center;
            font-size: 12px;
            color: #777;
            margin-top: 20px;
        }

        .footer small {
            font-size: 12px;
            color: #bbb;
        }

        .button {
            display: inline-block;
            background-color: #28a745;
            color: white;
            padding: 10px 20px;
            text-decoration: none;
            border-radius: 4px;
            margin-top: 15px;
        }

        .button:hover {
            background-color: #218838;
            color: black;
        }

        .button.text-black {
            color: black;
        }

        .button.text-white {
            color: white;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>Akun Login SIPIJAR</h2>
        </div>
        <div class="content">
            <p>Salam <span class="strong"><?php echo e($nama); ?></span>.</p>
            <p>Anda baru saja mengubah password baru. Berikut adalah detail akun login Anda :</p>
            <p>Username : <span class="strong"><?php echo e($username); ?></span></p>
            <p>Password : <span class="strong"><?php echo e($password); ?></span></p>
            <a href="localhost" class="button text-black">Login</a>
        </div>
        <div class="footer">
            <hr>
            <small>&copy; <?php echo e(date('Y')); ?> Sistem Informasi Pengelolaan Infrastruktur Jaringan</small>
        </div>
    </div>
</body>
</html><?php /**PATH D:\KAMPUS\SEMESTER 6\KP\aplikasi\SIPIJAR\resources\views/emails/akun.blade.php ENDPATH**/ ?>