@extends('layout.layout')
@section('title', 'SIPAJAR - Data Poligon')
@section('header', 'Data Poligon')
@section('konten')
    <div class="card">
        <div class="card-header">
            <div class="d-grip gap-2 d-md-flex justify-content-md-end">
                <a href="{{ route('poligon.create') }}" class="btn btn-primary me-md-2"><i class="bi bi-plus-lg"></i> Tambah
                    Data</a>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover table-bordered" id="table1">
                    <thead>
                        <tr>
                            <th class="text-center">No</th>
                            <th class="text-center">Branch</th>
                            <th class="text-center">Nama Proyek</th>
                            <th class="text-center">Tipe Desain</th>
                            <th class="text-center">Total BoQ</th>
                            <th class="text-center">Mitra</th>
                            <th class="text-center">Catatan</th>
                            <th class="text-center">Status</th>
                            <th class="text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $no = 1;
                        @endphp
                        @foreach ($data as $d)
                            <tr>
                                <td>{{ $no++ }}</td>
                                <td>{{ $d->branch->nama ?? 'Branch Terhapus' }}</td>
                                <td>{{ $d->nama }}</td>
                                <td>{{ $d->tipe }}</td>
                                <td>{{ number_format($d->total_boq, 0, ',', '.') }}</td>
                                <td>{{ $d->user->nama ?? $d->nama_user }}</td>
                                <td><button type="button" class="btn btn-outline-success btn-sm" data-bs-toggle="modal"
                                        data-bs-target="#catatan{{ $d->id }}">
                                        Catatan
                                    </button></td>
                                <td>
                                    @if (auth()->user()->hak_akses === 'Mitra')
                                        <span class="d-block mb-1">{{ $d->status }}</span>
                                    @else    
                                        <select class="form-select form-control status-select" data-id="{{ $d->id }}">
                                            <option value="">-- Pilih Update Status --</option>
                                            <option value="review" {{ $d->status === 'review' ? 'selected' : '' }}>Review</option>
                                            <option value="revisi" {{ $d->status === 'revisi' ? 'selected' : '' }}>Revisi</option>
                                            <option value="approval" {{ $d->status === 'approval' ? 'selected' : '' }}>Approval</option>
                                            <option value="kendala" {{ $d->status === 'kendala' ? 'selected' : '' }}>Kendala</option>
                                        </select>
                                        <span class="text-success small mt-1 status-message" style="display: none;"></span>
                                    @endif
                                </td>
                                <td>
                                    <a href="{{ route('poligon.show', $d->id) }}" class="btn btn-success btn-sm m-1"><i
                                            class="bi bi-eye-fill"></i> View</a>
                                    @if ($d->status === 'revisi' && auth()->user()->hak_akses === 'Mitra')
                                        <a href="{{ route('poligon.edit', $d->id) }}" class="btn btn-primary btn-sm m-1"><i
                                                class="bi bi-pencil-square"></i> Edit</a>
                                    @endif
                                    @if (auth()->user()->hak_akses !== 'Mitra')
                                        <a href="{{ route('poligon.edit', $d->id) }}" class="btn btn-primary btn-sm m-1"><i
                                            class="bi bi-pencil-square"></i> Edit</a>
                                        <form onsubmit="return confirm('Apakah Anda Yakin ?');"
                                            action="{{ route('poligon.destroy', $d->id) }}" method="POST" name="hapus">
                                            @method('DELETE')
                                            @csrf
                                            <button type="submit" class="btn btn-sm btn-danger m-1"><i
                                                    class="bi bi-trash"></i>
                                                Delete</button>
                                        </form>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
@foreach ($data as $d)
    <!--scrolling content Modal -->
    <div class="modal fade" id="catatan{{ $d->id }}" tabindex="-1" role="dialog"
        aria-labelledby="titlecatatan{{ $d->id }}" aria-hidden="true">
        <div class="modal-dialog modal-dialog-scrollable" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="titlecatatan{{ $d->id }}">
                        Catatan Poligon Branch {{ $d->branch->nama ?? '-' }} Proyek {{ $d->nama }}
                    </h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i data-feather="x"></i>
                    </button>
                </div>

                @livewire('catatan-poligon', ['id_poligon' => $d->id], key('catatan-' . $d->id))
            </div>
        </div>
    </div>
    @push('script')
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const modal = document.getElementById('catatan{{ $d->id }}');
            if (modal) {
                modal.addEventListener('shown.bs.modal', function () {
                    Livewire.dispatch('mulaiPolling');
                });
                modal.addEventListener('hidden.bs.modal', function () {
                    Livewire.dispatch('berhentiPolling');
                });
            }

            Livewire.hook('message.processed', (message, component) => {
                const container = document.querySelector('#list-catatan-{{ $d->id }}');
                if (container) {
                    container.scrollTop = container.scrollHeight;
                }
            });
        });
    </script>
    @endpush
@endforeach
@push('script')
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            document.querySelectorAll('.status-select').forEach(select => {
                select.addEventListener('change', function () {
                    const id = this.getAttribute('data-id');
                    const status = this.value;
                    const messageSpan = this.nextElementSibling;

                    fetch("{{ route('poligon.updateStatus') }}", {
                        method: "POST",
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                        },
                        body: JSON.stringify({ id, status })
                    })
                    .then(res => res.json())
                    .then(data => {
                        messageSpan.textContent = data.message;
                        messageSpan.style.display = 'inline';
                        setTimeout(() => {
                            messageSpan.style.display = 'none';
                        }, 2000);
                    })
                    .catch(err => {
                        alert('Gagal update status');
                        console.error(err);
                    });
                });
            });
        });
    </script>
@endpush
