@extends('layout.layout')
@section('title', 'SIPAJAR - Data Branch')
@section('header', 'Data Branch')
@section('konten')
    <div class="card">
        <div class="card-header">
            <div class="d-grip gap-2 d-md-flex justify-content-md-end">
                <a href="{{ route('branch.create') }}" class="btn btn-primary me-md-2"><i class="bi bi-plus-lg"></i> Tambah
                    Data</a>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover table-bordered" id="table1">
                    <thead>
                        <tr>
                            <th class="text-center">No</th>
                            <th class="text-center">Nama Branch</th>
                            <th class="text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $no = 1;
                        @endphp
                        @foreach ($data as $d)
                            <tr>
                                <td class="text-center">{{ $no++ }}</td>
                                <td>{{ $d->nama }}</td>
                                <td>
                                    <a href="{{ route('branch.edit', $d->id) }}" class="btn btn-success btn-sm m-1"><i
                                            class="bi bi-pencil-square"></i> Edit</a>
                                    <form onsubmit="return confirm('Apakah Anda Yakin ?');"
                                        action="{{ route('branch.destroy', $d->id) }}" method="POST" name="hapus">
                                        @method('DELETE')
                                        @csrf
                                        <button type="submit" class="btn btn-sm btn-danger m-1"><i class="bi bi-trash"></i>
                                            Delete</button>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
