@extends('layout.layout')
@section('title', 'SIPIJAR - Pengaturan Akun')
@section('header', 'Pengaturan Akun')
@section('konten')
    <div class="row">
        <div class="col-12 col-lg-4">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-center align-items-center flex-column">
                        <div class="avatar avatar-2xl">
                            <img src="{{ route('foto.profil', ['userId' => auth()->user()->id, 'filename' => basename(auth()->user()->foto)]) }}" alt="Avatar">
                        </div>

                        <h3 class="mt-3">{{ auth()->user()->nama }}</h3>
                        <p class="text-small">{{ auth()->user()->hak_akses }}</p>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12 col-lg-8">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('pengaturan.update', auth()->user()->id) }}" method="post" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="form-group">
                            <label for="nama" class="form-label">Nama Lengkap <span class="text-danger">*</span></label>
                            <input type="text" name="nama" id="nama" class="form-control" placeholder="Masukkan Nama Lengkap" value="{{ auth()->user()->nama }}" required autofocus>
                        </div>
                        <div class="form-group">
                            <label for="nomor_induk" class="form-label">Nomor Induk <span class="text-danger">*</span></label>
                            <input type="text" name="nomor_induk" id="nomor_induk" class="form-control" placeholder="Masukkan Nomor Induk" value="{{ auth()->user()->nomor_induk }}" disabled>
                        </div>
                        <div class="form-group">
                            <label for="password" class="form-label">Password</label>
                            <input type="password" name="password" id="password" class="form-control" placeholder="Masukkan Password">
                            <small class="text-danger">Kosongkan jika tidak ingin mengganti Password</small>
                        </div>
                        <div class="form-group">
                            <label for="email" class="form-label">Email</label>
                            <input type="email" name="email" id="email" class="form-control" placeholder="Masukkan Email" value="{{ auth()->user()->email ?? '' }}" required>
                        </div>
                        <div class="form-group">
                            <label for="file" class="form-label">Foto</label>
                            <input type="file" name="file" id="file" class="form-control" accept="image/png, image/jpeg, image/jpg">
                            <small class="text-danger">Kosongkan jika tidak ingin mengganti Foto</small>
                        </div>
                            <div class="form-group">
                                <label for="role" class="form-label">Hak Akses <span class="text-danger">*</span></label>
                                <select name="role" id="role" class="form-select" disabled>
                                    <option value="">-- Pilih Hak Akses --</option>
                                    <option value="Admin"{{ auth()->user()->hak_akses == 'Admin' ? 'selected' : '' ; }}>Admin</option>
                                    <option value="SDI" {{ auth()->user()->hak_akses == 'SDI' ? 'selected' : '' ; }}>SDI</option>
                                    <option value="Mitra" {{ auth()->user()->hak_akses == 'Mitra' ? 'selected' : '' ; }}>Mitra</option>
                                </select>
                            </div>
                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection