@extends('layout.layout')

@section('title', 'SIPAJAR - Laporan Poligon')
@section('header', 'Laporan Poligon')
@section('konten')

    <div class="card">
        <div class="card-header">
            <div class="d-grip gap-2 d-md-flex justify-content-md-end">
                <form method="GET" action="{{ route('laporan.index') }}" class="d-flex justify-content-between">
                    @csrf
                    <div class="row">
                        <div class="col-4 col-lg-4">
                            <div class="form-group">
                                <label for="branch">Branch :</label>
                                <select name="branch" id="branch" class="form-control">
                                    <option value="">-- Pilih Branch --</option>
                                    @foreach ($branches as $branch)
                                        <option value="{{ $branch->id }}" {{ $branch->id == request()->branch ? 'selected' : '' }}>
                                            {{ $branch->nama }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-4 col-lg-4">
                            <div class="form-group">
                                <label for="status">Status :</label>
                                <select name="status" id="status" class="form-control">
                                    <option value="">-- Pilih Status --</option>
                                    <option value="review" {{ request()->status == 'review' ? 'selected' : '' }}>Review</option>
                                    <option value="revisi" {{ request()->status == 'revisi' ? 'selected' : '' }}>Revisi</option>
                                    <option value="approval" {{ request()->status == 'approval' ? 'selected' : '' }}>Approval</option>
                                    <option value="kendala" {{ request()->status == 'kendala' ? 'selected' : '' }}>Kendala</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-4 col-lg-4"><br>
                            <button type="submit" class="btn btn-primary me-md-2"><i class="bi bi-search"></i> Filter</button>
                        </div>
                    </div>
                </form>
            </div>
            
        </div>

        <div class="card-body">
            <!-- Menampilkan Data jika ada -->
            @if ($data->isNotEmpty())
                <div class="table-responsive">
                    <table class="table table-hover table-bordered" id="table1">
                        <thead>
                            <tr>
                                <th class="text-center">No</th>
                                <th class="text-center">Branch</th>
                                <th class="text-center">Nama Proyek</th>
                                <th class="text-center">Tipe Desain</th>
                                <th class="text-center">Total BoQ</th>
                                <th class="text-center">Mitra</th>
                                <th class="text-center">Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($data as $d)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $d->branch->nama ?? 'Branch Tidak Ditemukan' }}</td>
                                    <td>{{ $d->nama }}</td>
                                    <td>{{ $d->tipe }}</td>
                                    <td>{{ number_format($d->total_boq, 0, ',', '.') }}</td>
                                    <td>{{ $d->user->nama ?? 'Mitra Tidak Ditemukan' }}</td>
                                    <td>{{ ucfirst($d->status) }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Tombol Export -->
                <div class="mt-3 text-end">
                    <a href="{{ route('laporan.export', ['branch' => request('branch'), 'status' => request('status')]) }}"
                        class="btn btn-success">
                        <i class="bi bi-file-spreadsheet-fill"></i> Export to Excel
                    </a>
                </div>
            @else
                <div class="alert alert-info mt-3">
                    Tidak ada data yang ditemukan. Silakan sesuaikan filter.
                </div>
            @endif
        </div>
    </div>
@endsection
