<div @if($pollingAktif) wire:poll.5s @endif>
    <div class="modal-body" id="list-catatan-{{ $id_poligon }}" style="max-height: 400px; overflow-y: auto;">
        @forelse ($catatans as $catatan)
            <div class="mb-3">
                <div class="d-flex {{ auth()->id() === ($catatan->id_user ?? $catatan->nama_user) ? 'justify-content-end' : 'justify-content-start' }}">
                    <div class="p-2 rounded text-white {{ auth()->id() === ($catatan->id_user ?? $catatan->nama_user) ? 'bg-primary' : 'bg-secondary' }}"
                         style="max-width: 75%;">
                        <small><strong>{{ $catatan->user->nama ?? $catatan->nama_user }}</strong></small><br>
                        <span>{{ $catatan->catatan }}</span><br>
                        <small class="text-light">{{ $catatan->created_at->format('d M Y H:i') }}</small>
                    </div>
                </div>
            </div>
        @empty
            <p class="text-center text-muted">Belum ada catatan.</p>
        @endforelse
    </div>

    <div class="modal-footer">
        <form wire:submit.prevent="simpanCatatan" class="d-flex gap-2 w-100">
            <input type="text" wire:model.defer="catatan" class="form-control" placeholder="Tulis catatan..." required>
            <button type="submit" class="btn btn-primary">Kirim</button>
        </form>
    </div>
</div>
