var chartColors = {
  red: "rgb(255, 99, 132)",
  orange: "rgb(255, 159, 64)",
  yellow: "rgb(255, 205, 86)",
  green: "rgb(75, 192, 192)",
  info: "#41B1F9",
  blue: "#3245D1",
  purple: "rgb(153, 102, 255)",
  grey: "#EBEFF6",
}

var jSuratMasuk = Object.values(jSMasuk);
var jSuratKeluar = Object.values(jSKeluar);

var srtMasuk = document.getElementById("masuk").getContext("2d");
var myMasuk = new Chart(srtMasuk, {
  type: "bar",
  data: {
    labels: labels,
    datasets: [{
      label: "Surat Masuk",
      backgroundColor: chartColors.green,
      data: jSuratMasuk,
    }],
  },
  options: {
    responsive: true,
    title: {
      display: true,
      text: "Jumlah Surat Masuk per Bulan",
    },
    legend: {
      display: false,
    },
    scales: {
      y: [{
        ticks: {
          beginAtZero: true,
          suggestedMax: Math.max(...jSuratMasuk) + 10,
        },
      }],
    },
  },
});

var srtKeluar = document.getElementById("keluar").getContext("2d");
var myKeluar = new Chart(srtKeluar, {
  type: "bar",
  data: {
    labels: labels,
    datasets: [{
      label: "Surat Keluar",
      backgroundColor: chartColors.blue,
      data: jSuratKeluar,
    }],
  },
  options: {
    responsive: true,
      title: {
        display: true,
        text: "Jumlah Surat Keluar per Bulan",
    },
    legend: {
      display: false,
    },
    scales: {
      y: [{
        ticks: {
          beginAtZero: true,
          suggestedMax: Math.max(...jSuratKeluar) + 10,
        },
      }],
    },
  },
});

// let ctx1 = document.getElementById("canvas1").getContext("2d");
// let ctx2 = document.getElementById("canvas2").getContext("2d");
// let ctx3 = document.getElementById("canvas3").getContext("2d");
// let ctx4 = document.getElementById("canvas4").getContext("2d");
// var lineChart1 = new Chart(ctx1, config1);
// var lineChart2 = new Chart(ctx2, config2);
// var lineChart3 = new Chart(ctx3, config3);
// var lineChart4 = new Chart(ctx4, config4);
