<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('poligons', function (Blueprint $table) {
            $table->id();
            $table->foreignId('id_branch')->nullable()->constrained('branches')->onDelete('set null');
            $table->string('nama', 100);
            $table->enum('tipe', ['PT 3', 'CSF', 'FEEDER']);
            $table->string('file_kml', 200);
            $table->string('file_boq', 200);
            $table->foreignId('id_user')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('poligons');
    }
};
