<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Poligon extends Model
{
    use HasFactory;

    protected $fillable = [
        'id_branch',
        'nama',
        'tipe',
        'file_kml',
        'file_boq',
        'total_boq',
        'total_port',
        'id_user',
        'status',
        'nama_user',
        'temp_id'
    ];

    protected $table = 'poligons';

    public function user()
    {
        return $this->belongsTo(User::class, 'id_user');
    }
    public function branch()
    {
        return $this->belongsTo(Branch::class, 'id_branch');
    }
}
