<?php

namespace App\Livewire;

use App\Models\Catatan;
use Livewire\Component;

class CatatanPoligon extends Component
{
    public $id_poligon;
    public $catatan;
    public $pollingAktif = false;


    public function mulaiPolling()
    {
        $this->pollingAktif = true;
    }

    public function berhentiPolling()
    {
        $this->pollingAktif = false;
    }
    public function mount($id_poligon)
    {
        $this->id_poligon = $id_poligon;
    }

    public function simpanCatatan()
    {
        $this->validate([
            'catatan' => 'required|string'
        ]);

        Catatan::create([
            'id_poligon' => $this->id_poligon,
            'id_user' => auth()->id(),
            'catatan' => $this->catatan,
        ]);

        $this->catatan = '';
    }

    public function render()
    {
        $catatans = Catatan::where('id_poligon', $this->id_poligon)
                    ->with('user')
                    ->oldest() // ubah dari ->latest() menjadi ->oldest()
                    ->get();

        return view('livewire.catatan-poligon', compact('catatans'));
    }
    protected $listeners = [
        'mulaiPolling' => 'mulaiPolling',
        'berhentiPolling' => 'berhentiPolling',
    ];
}
