<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use RealRashid\SweetAlert\Facades\Alert;

class PengaturanController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return view('main.pengaturan');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $validasi = $request->validate([
            'nama'          => 'required',
            'password'      => 'nullable|min:8',
            'email'         => 'required|unique:users,email,' . $id,
            'file'          => 'nullable|mimes:jpg,jpeg,png|max:2048',
        ],[
            'nama.required'     => 'Nama harus diisi!',
            'email.required'    => 'Email harus diisi!',
            'email.unique'      => 'Email sudah terdaftar di sistem!',
            'file.mimes'        => 'Foto harus ekstensi JPG, JPEG, PNG!',
            'file.max'          => 'Max ukuran foto 2MB!',
            'password.min'      => 'Password minimal 8 karakter!',
        ]);
        DB::beginTransaction();
        try {
            $user = User::findOrFail($id);
            $user->nama = strip_tags($request->nama);
            $user->email = strip_tags($request->email);
            if ($request->filled('password')) {
                $user->password = bcrypt(strip_tags($request->password));
            }
            if ($request->hasFile('file')) {
                $file = $request->file('file');
                $namaFile = time() . '_' . $file->getClientOriginalName();
                $path = 'file/profile/' . $user->id;

                // Hapus foto lama jika ada, dan bukan foto default
                if ($user->foto && Storage::exists($user->foto)) {
                    $defaultFoto = 'file/profile/1.jpg';
                    if ($user->foto !== $defaultFoto) {
                        Storage::delete($user->foto);
                    }
                }

                // Simpan foto baru
                $filePath = $file->storeAs($path, $namaFile);
                $user->foto = $filePath; // Simpan path ke database
            }
            $user->save();
            DB::commit();
            return redirect()->back()->withSuccess('Akun Berhasil di Update!');
        } catch (\Exception $e) {
            DB::rollback(); //batalkan transaksi jika ada error
            Alert::error('Terjadi kesalahan' . $e->getMessage());
            return back();
        }

    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
