<?php

namespace App\Http\Controllers;

use App\Models\Branch;
use App\Models\Poligon;
use Illuminate\Http\Request;
use App\Exports\PoligonExport;
use Maatwebsite\Excel\Facades\Excel;

class LaporanExcelController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $branch = $request->input('branch');
        $status = $request->input('status');

        $branches = Branch::all();
        $data = collect(); // Default kosong

        $user = auth()->user();

        if ($branch || $status || $user->hak_akses === 'Mitra') {
            $query = Poligon::query();

            // Mitra hanya bisa lihat data miliknya
            if ($user->hak_akses === 'Mitra') {
                $query->where('id_user', $user->id);
            }

            if ($branch) {
                $query->where('id_branch', $branch);
            }

            if ($status) {
                $query->where('status', $status);
            }

            $data = $query->with('branch', 'user')->get();
        }

        return view('main.laporan.laporan', compact('data', 'branches', 'branch', 'status'));
    }



    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    public function exportManual(Request $request)
{
    $branch = $request->input('branch');
    $status = $request->input('status');

    return Excel::download(new PoligonExport($branch, $status), 'laporan_poligon.xlsx');
}
}
