<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class FileController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show($type, $userId, $filename)
    {
        $allowedTypes = ['boq', 'kml', 'profile'];
        $user = auth()->user();
        $allowedRoles = ['Admin', 'SDI'];
        $isAllowed = ($user->id == $userId) || in_array($user->hak_akses, $allowedRoles);
        if (!in_array($type, $allowedTypes)) {
            abort(404, 'Jenis file tidak dikenal');
        }

        if (!$isAllowed) {
            abort(403, 'Tidak diizinkan');
        }

        $path = "file/{$type}/{$userId}/{$filename}";

        if (!Storage::disk('local')->exists($path)) {
            abort(404, 'File tidak ditemukan');
        }

        $file = Storage::disk('local')->get($path);
        $mime = Storage::disk('local')->mimeType($path);

        return response($file)
            ->header('Content-Type', $mime)
            ->header('Content-Disposition', 'attachment; filename="' . $filename . '"');
    }


    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    public function showProfileImage($userId, $filename = null)
    {
        // Tentukan path file user atau default
        $path = $filename
            ? "file/profile/{$userId}/{$filename}"
            : "file/profile/1.jpg";

        // Jika file tidak ditemukan, fallback ke default
        if (!Storage::disk('local')->exists($path)) {
            $path = "file/profile/1.jpg";
        }

        if (auth()->id() != $userId) {
            abort(403, 'Tidak diizinkan');
        }
        $file = Storage::disk('local')->get($path);
        $mime = Storage::disk('local')->mimeType($path);

        return response($file)->header('Content-Type', $mime);
    }
}
