<?php

namespace App\Http\Controllers;

use App\Models\Catatan;
use Illuminate\Http\Request;

class CatatanController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'catatan' => 'required|string',
            'id_poligon' => 'required|exists:poligons,id',
        ]);

        Catatan::create([
            'id_user'    => auth()->id(),
            'id_poligon' => $request->id_poligon,
            'catatan'    => strip_tags($request->catatan),
        ]);

        return response()->json(['success' => true]);
    }

    /**
     * Display the specified resource.
     */
    public function show(Catatan $catatan)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Catatan $catatan)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Catatan $catatan)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Catatan $catatan)
    {
        //
    }

    public function list($id_poligon)
    {
        $catatans = Catatan::where('id_poligon', $id_poligon)->with('user')->latest()->get();
        return view('main.catatan._list', compact('catatans'));
    }
}
