<?php

namespace App\Http\Controllers;

use App\Models\Branch;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use RealRashid\SweetAlert\Facades\Alert;

class BranchController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $data = Branch::get();
        return view('order.branch', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('order.resource.branch.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validasi = $request->validate([
            'nama'      => 'required',
        ],[
            'nama.required'     => 'Nama Branch Harus Diisi!'
        ]);

        DB::beginTransaction();
        try {
            $data = array_map('strip_tags', [
                'nama'     => $validasi['nama'],
            ]);
            Branch::create($data);
            DB::commit();
            Alert::success('Data Berhasil Di Tambahkan!');
            return redirect()->route('branch.index');
        } catch (\Exception $e) {
            DB::rollback(); //batalkan transaksi jika ada error
            Alert::error('Terjadi kesalahan' . $e->getMessage());
            return back();
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Branch $branch)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $data = Branch::where('id', $id)->firstOrFail();
        return view('order.resource.branch.edit', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $validasi = $request->validate([
            'nama'      => 'required',
        ],[
            'nama.required'     => 'Nama Branch Harus Diisi!'
        ]);

        DB::beginTransaction();
        try {
            $data = array_map('strip_tags', [
                'nama'     => $validasi['nama'],
            ]);
            $branch = Branch::where('id', $id)->firstOrFail();
            $branch->update($data);
            DB::commit();
            Alert::success('Data Berhasil Di Edit!');
            return redirect()->route('branch.index');
        } catch (\Exception $e) {
            DB::rollback(); //batalkan transaksi jika ada error
            Alert::error('Terjadi kesalahan' . $e->getMessage());
            return back();
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        if (empty($id)) {
            Alert::error('ID Tidak Valid!');
            return redirect()->back();
        }
        DB::beginTransaction();
        try {
            $data = Branch::findOrFail($id);
            $data->delete();
            DB::commit();
            Alert::success('Data Berhasil Dihapus!');
            return redirect()->back();
        } catch (\Exception $e) {
            DB::rollback(); //batalkan transaksi jika ada error
            Alert::error('Terjadi kesalahan' . $e->getMessage());
            return back();
        }
    }
}
