<?php

namespace App\Console\Commands;

use Carbon\Carbon;
use App\Models\OTP;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class RejectExpiredOtps extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'otp:reject-expired';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Menolak input OTP yang sudah expired';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $expiredOtps = OTP::where('verifikasi', false)
                        ->where('expired_at', '<', Carbon::now())
                        ->get();

        DB::transaction(function () use($expiredOtps) {
            foreach($expiredOtps as $otp) {
                $otp->delete();
            }
        });
        return 0;
    }
}
